%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
function sys_state = Closed_sys_performance(t,xx,A,Delta_A,B,F,D,C,K,L)
global tmp count ts ex1 ex2 ef ff

[n,m] = size(B);
[~,q] = size(F);
[p,~] = size(C);

X = xx(1:n);
hat_X_bar = xx(n+1:end);

% augmented system
A_bar = [A F zeros(n,q); zeros(q,n) zeros(q,q) eye(q); zeros(q,n) zeros(q,q) zeros(q,q)];
B_bar = [B;zeros(q,m);zeros(q,m)];
C_bar = [C zeros(p,q) zeros(p,q)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% disturbance and fault
d = 0.001 * sin(1*t);
if t <= 10
    f = 0;
elseif 10 < t & t <= 20
    f = 0.1;
elseif 20 < t  & t <= 30
    f = 0;
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
y = C*X;
hat_y = C_bar*hat_X_bar;

% controller
Kf = -pinv(B)*F;
hat_X = hat_X_bar(1:n);
hat_f = hat_X_bar(n+1);

u = K*hat_X + Kf*hat_f;

%observer
dot_hat_X_bar = A_bar*hat_X_bar + B_bar*u + L*(y-hat_y);

% sys dynamic
Delta_At = Delta_A*sin(pi/10*t);
dot_X = (A + Delta_At)*X + B*u + F*f + D*d;

% data saving 
if mod(tmp,20)==0
    count = count + 1;
ts(count) = t;
ex1(count) = abs(X(1) - hat_X(1));
ex2(count) = abs(X(2) - hat_X(2));
ef(count) = abs(f - hat_f);
ff(count) = f;
end
tmp = tmp + 1;

sys_state = [dot_X;dot_hat_X_bar];